#!/bin/bash

set -x 

# Check if the system is running Ubuntu 22.04
if grep -q "DISTRIB_RELEASE=22.04" /etc/lsb-release; then
  echo "Ubuntu 22.04 detected"

  # Install Squid Proxy version 5.9-0ubuntu0.22.04.4
  dpkg -i squid_5.9-0ubuntu0.22.04.4_amd64.deb
  # Install Google Chrome version 142.0.7444.59
  dpkg -i google-chrome-stable_142.0.7444.59-1_amd64.deb || echo "Chrome installation failed"

  # Unzip the ChromeDriver binary to /usr/local/bin
  /usr/bin/unzip -j -o chromedriver-linux64.zip -d /usr/local/bin/ chromedriver-linux64/chromedriver 2>&1

  # Create a symbolic link for chromedriver in /usr/bin
  ln -sfn /usr/local/bin/chromedriver /usr/bin/chromedriver

else
  echo "Unable to install Google Chrome package due to unsupported Ubuntu version"
fi

