#!/bin/bash

set -x 

# Check if the system is running Ubuntu 22.04
if grep -q "DISTRIB_RELEASE=22.04" /etc/lsb-release; then
  echo "Ubuntu 22.04 detected"

  # Install Packages - Google Chrome, Microsoft Edge, Open VM Tools, Linux Kernels
  dpkg -i *.deb || echo "Packages installation failed"

  # Unzip the Chrome & Edge driver binaries to /usr/local/bin
  /usr/bin/unzip -j -o chromedriver-linux64.zip -d /usr/local/bin/ chromedriver-linux64/chromedriver 2>&1
  /usr/bin/unzip -o edgedriver_linux64.zip -d /usr/local/bin/ msedgedriver 2>&1
  
  # Create a symbolic link for chromedriver in /usr/bin
  ln -sfn /usr/local/bin/chromedriver /usr/bin/chromedriver
  ln -sfn /usr/local/bin/msedgedriver /usr/bin/msedgedriver

else
  echo "Unable to install Google Chrome package due to unsupported Ubuntu version"
fi

